/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.gamelogic;

import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.utils.Array;
import com.skloch.game.gamelogic.EventManager;
import com.skloch.game.gamelogic.Player;

public class DialogueBox {
    private Window dialogueWindow;
    private Table dialogueTable;
    private Label textLabel;
    private Skin skin;
    private static final int MAX_CHARS = 35;
    private SelectBox selectBox;
    private Array<String> textLines;
    private int linePointer = 0;
    private String eventKey = null;
    private float textCounter = 0.0f;
    private boolean scrollingText = false;
    private final Player player;

    public DialogueBox(Skin skin, Player player) {
        this.skin = skin;
        this.player = player;
        this.dialogueWindow = new Window("", skin);
        this.dialogueTable = new Table();
        this.dialogueWindow.addActor(this.dialogueTable);
        this.dialogueTable.setFillParent(true);
        int width = 800;
        this.textLabel = new Label("Are you sure you want to sleep at the Piazza? This will cost you 10 energy", skin, "dialogue");
        this.dialogueTable.add(this.textLabel).expand().width(width - 80).top().padTop(40.0f);
        this.textLabel.setWrap(false);
        int height = 200;
        this.dialogueWindow.setWidth(width);
        this.dialogueWindow.setHeight(height);
        this.selectBox = new SelectBox();
        this.selectBox.setOptions(new String[]{"Yes", "No"}, new String[]{"piazza", "close"});
        this.setText("Are you sure you want to sleep at the Piazza? This will cost you 10 energy");
    }

    public void setPos(float x, float y) {
        this.dialogueWindow.setPosition(x, y);
        this.selectBox.selectWindow.setPosition(x + this.dialogueWindow.getWidth() - this.selectBox.selectWindow.getWidth(), y + this.dialogueWindow.getHeight() - 24.0f);
    }

    public void setText(String text) {
        this.initialiseLabelText(text);
        this.scrollingText = true;
        this.textCounter = 0.0f;
    }

    public void setText(String text, String eventKey) {
        this.initialiseLabelText(text);
        this.eventKey = eventKey;
        this.scrollingText = true;
        this.textCounter = 0.0f;
    }

    public void scrollText(float speed) {
        if (this.scrollingText) {
            this.textCounter += speed;
            if (Math.round(this.textCounter) >= this.textLines.get(this.linePointer).length()) {
                this.scrollingText = false;
                this.textLabel.setText(this.textLines.get(this.linePointer));
            }
            this.textLabel.setText(this.textLines.get(this.linePointer).substring(0, Math.round(this.textCounter)));
        }
    }

    public void initialiseLabelText(String text) {
        String newString = "";
        int lastSpace = 0;
        int index = 0;
        int totalIndex = 0;
        for (char c : text.toCharArray()) {
            if (c == '\n') {
                index = 0;
            }
            if (index >= 35) {
                if (c == ' ') {
                    newString = newString + "\n";
                    ++totalIndex;
                    index = 0;
                    continue;
                }
                if (lastSpace == 0 || totalIndex - lastSpace >= 35) {
                    newString = newString + "\n";
                    index = 0;
                    continue;
                }
                newString = newString.substring(0, lastSpace) + "\n" + newString.substring(lastSpace + 1);
                newString = newString + c;
                index = totalIndex - lastSpace;
                ++totalIndex;
                continue;
            }
            newString = newString + c;
            if (c == ' ') {
                lastSpace = totalIndex;
            }
            ++index;
            ++totalIndex;
        }
        this.textLines = new Array();
        int numBreaks = 0;
        String subString = "";
        for (String s : newString.split("\n")) {
            if (numBreaks == 2) {
                subString = subString + s;
                this.textLines.add(subString);
                subString = "";
                numBreaks = 0;
                continue;
            }
            subString = subString + s + "\n";
            ++numBreaks;
        }
        if (subString != "") {
            this.textLines.add(subString);
        }
        this.textLabel.setText(this.textLines.get(0));
        this.linePointer = 0;
    }

    public void show() {
        this.dialogueWindow.setVisible(true);
        this.player.setMoving(false);
        this.player.setRunning(false);
    }

    public void hide() {
        this.dialogueWindow.setVisible(false);
        this.selectBox.hide();
    }

    public void enter(EventManager eventManager) {
        if (this.selectBox.isVisible()) {
            this.selectBox.hide();
            eventManager.event(this.selectBox.getChoice());
        } else {
            this.advanceText(eventManager);
        }
    }

    private void advanceText(EventManager eventManager) {
        if (this.scrollingText) {
            this.scrollingText = false;
            this.textCounter = 0.0f;
            this.textLabel.setText(this.textLines.get(this.linePointer));
        } else {
            ++this.linePointer;
            if (this.linePointer >= this.textLines.size) {
                this.hide();
                this.scrollingText = false;
                this.textCounter = 0.0f;
                if (this.eventKey != null) {
                    eventManager.event(this.eventKey);
                    this.eventKey = null;
                }
            } else {
                this.textCounter = 0.0f;
                this.scrollingText = true;
            }
        }
    }

    public void hideSelectBox() {
        this.selectBox.hide();
    }

    public boolean isVisible() {
        return this.dialogueWindow.isVisible();
    }

    public Window getWindow() {
        return this.dialogueWindow;
    }

    public float getWidth() {
        return this.dialogueWindow.getWidth();
    }

    public float getHeight() {
        return this.dialogueWindow.getHeight();
    }

    public SelectBox getSelectBox() {
        return this.selectBox;
    }

    public class SelectBox {
        private Window selectWindow;
        private Table selectTable;
        private int choiceIndex = 0;
        private String[] options;
        private String[] events;
        private Array<Label> optionPointers = new Array();

        public SelectBox() {
            this.selectWindow = new Window("", DialogueBox.this.skin);
            this.selectTable = new Table();
            this.selectWindow.add(this.selectTable);
            this.selectWindow.setPosition(DialogueBox.this.dialogueWindow.getX() + DialogueBox.this.dialogueWindow.getWidth() - this.selectWindow.getWidth(), DialogueBox.this.dialogueWindow.getY() + DialogueBox.this.dialogueWindow.getHeight() - 24.0f);
        }

        public void setOptions(String[] options, String[] events) {
            this.selectTable.clearChildren();
            this.options = options;
            this.events = events;
            this.optionPointers.clear();
            for (String option : options) {
                Label pointer = new Label(">", DialogueBox.this.skin, "dialogue");
                this.optionPointers.add(pointer);
                this.selectTable.add(pointer).padRight(10.0f).padLeft(10.0f);
                pointer.setVisible(false);
                this.selectTable.add(new Label(option, DialogueBox.this.skin, "dialogue")).left().padRight(10.0f);
                this.selectTable.row();
            }
            this.selectTable.pack();
            this.selectWindow.setWidth(this.selectTable.getWidth() + 70.0f);
            this.selectWindow.setHeight(this.selectTable.getHeight() + 70.0f);
            this.selectWindow.setPosition(DialogueBox.this.dialogueWindow.getX() + DialogueBox.this.dialogueWindow.getWidth() - this.selectWindow.getWidth(), DialogueBox.this.dialogueWindow.getY() + DialogueBox.this.dialogueWindow.getHeight() - 24.0f);
            this.setChoice(0);
            this.show();
        }

        public void choiceUp() {
            this.optionPointers.get(this.choiceIndex).setVisible(false);
            --this.choiceIndex;
            if (this.choiceIndex < 0) {
                this.choiceIndex = 0;
            }
            this.optionPointers.get(this.choiceIndex).setVisible(true);
        }

        public void choiceDown() {
            this.optionPointers.get(this.choiceIndex).setVisible(false);
            ++this.choiceIndex;
            if (this.choiceIndex >= this.options.length) {
                this.choiceIndex = this.options.length - 1;
            }
            this.optionPointers.get(this.choiceIndex).setVisible(true);
        }

        public String getChoice() {
            return this.events[this.choiceIndex];
        }

        public Window getWindow() {
            return this.selectWindow;
        }

        public void hide() {
            this.selectWindow.setVisible(false);
        }

        public void show() {
            this.selectWindow.setVisible(true);
            DialogueBox.this.player.setMoving(false);
            DialogueBox.this.player.setRunning(false);
        }

        public boolean isVisible() {
            return this.selectWindow.isVisible();
        }

        public void setChoice(int index) {
            if (this.choiceIndex < this.options.length) {
                this.optionPointers.get(this.choiceIndex).setVisible(false);
            }
            this.choiceIndex = index;
            this.optionPointers.get(this.choiceIndex).setVisible(true);
        }
    }
}

